<?php

/**
 *
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 *
 * SuiteCRM is an extension to SugarCRM Community Edition developed by SalesAgility Ltd.
 * Copyright (C) 2011 - 2018 SalesAgility Ltd.
 *
 * MintHCM is a Human Capital Management software based on SuiteCRM developed by MintHCM,
 * Copyright (C) 2018-2023 MintHCM
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by SugarCRM"
 * logo and "Supercharged by SuiteCRM" logo and "Reinvented by MintHCM" logo.
 * If the display of the logos is not reasonably feasible for technical reasons, the
 * Appropriate Legal Notices must display the words "Powered by SugarCRM" and
 * "Supercharged by SuiteCRM" and "Reinvented by MintHCM".
 */
$dictionary['Certificates'] = array(
    'table' => 'certificates',
    'audited' => true,
    'activity_enabled' => false,
    'duplicate_merge' => true,
    'fields' => array(
        'documents' => array(
            'name' => 'documents',
            'type' => 'link',
            'relationship' => 'documents_certificates',
            'source' => 'non-db',
            'vname' => 'LBL_DOCUMENTS',
        ),
        "trainings" => array(
            'name' => 'trainings',
            'type' => 'link',
            'relationship' => 'certificates_trainings',
            'source' => 'non-db',
            'module' => 'Trainings',
            'bean_name' => 'Trainings',
            'vname' => 'LBL_RELATIONSHIP_TRAININGS_NAME',
        ),
        "employeecertificates" => array(
            'name' => 'employeecertificates',
            'type' => 'link',
            'relationship' => 'certificates_employeecertificates',
            'source' => 'non-db',
            'module' => 'EmployeeCertificates',
            'bean_name' => 'EmployeeCertificates',
            'vname' => 'LBL_EMPLOYEE_CERTIFICATES',
        ),
        'attempts_number' => array(
            'name' => 'attempts_number',
            'vname' => 'LBL_ATTEMPTS_NUMBER',
            'label' => 'LBL_ATTEMPTS_NUMBER',
            'type' => 'int',
            'importable' => 'true',
            'reportable' => true,
            'audited' => true,
            'validation' => array (
                'type' => 'range',
                'min' => 0,
                'max' => false,
            ),
            'min' => 0,
            'max' => false,
            'duplicate_merge' => 'enabled',    
            'size' => 30,    
            'enable_range_search' => true,
            'options' => 'numeric_range_search_dom',
            'disable_num_format' => true,
        ),
        'duration' => array(
            'name' => 'duration',
            'vname' => 'LBL_DURATION',
            'label' => 'LBL_DURATION',
            'type' => 'int',
            'importable' => 'true',
            'reportable' => true,
            'audited' => true,
            'validation' => array (
                'type' => 'range',
                'min' => 0,
                'max' => false,
            ),
            'min' => 0,
            'max' => false,
            'duplicate_merge' => 'enabled',    
            'size' => 30,    
            'enable_range_search' => true,
            'options' => 'numeric_range_search_dom',
            'disable_num_format' => true,
        ),
        'pass_rate' => array(
            'name' => 'pass_rate',
            'vname' => 'LBL_PASS_RATE',
            'label' => 'LBL_PASS_RATE',
            'type' => 'int',
            'importable' => 'true',
            'reportable' => true,
            'audited' => true,
            'validation' => array (
                'type' => 'range',
                'min' => 0,
                'max' => false,
            ),
            'min' => 0,
            'max' => false,
            'duplicate_merge' => 'enabled',    
            'size' => 30,    
            'enable_range_search' => true,
            'options' => 'numeric_range_search_dom',
            'disable_num_format' => true,
        ),
        
    ),
    'relationships' => array(
    ),
    'optimistic_locking' => true,
    'unified_search' => true,
);

if (!class_exists('VardefManager')) {
    require_once 'include/SugarObjects/VardefManager.php';
}
VardefManager::createVardef('Certificates', 'Certificates',
    array('basic', 'assignable', 'security_groups'));
