<?php


/**
 *
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 *
 * SuiteCRM is an extension to SugarCRM Community Edition developed by SalesAgility Ltd.
 * Copyright (C) 2011 - 2018 SalesAgility Ltd.
 *
 * MintHCM is a Human Capital Management software based on SuiteCRM developed by MintHCM, 
 * Copyright (C) 2018-2023 MintHCM
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by SugarCRM" 
 * logo and "Supercharged by SuiteCRM" logo and "Reinvented by MintHCM" logo. 
 * If the display of the logos is not reasonably feasible for technical reasons, the 
 * Appropriate Legal Notices must display the words "Powered by SugarCRM" and 
 * "Supercharged by SuiteCRM" and "Reinvented by MintHCM".
 */

/* * *******************************************************************************
 * SugarCRM is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2011 SugarCRM Inc.
 * 
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 * 
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 * 
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 * 
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by
 * SugarCRM" logo. If the display of the logo is not reasonably feasible for
 * technical reasons, the Appropriate Legal Notices must display the words
 * "Powered by SugarCRM".
 * ****************************************************************************** */

$dictionary['Delegations'] = array(
   'table' => 'delegations',
   'audited' => true,
   'fields' => array(
      'delegation_id' => array(
         'required' => false,
         'name' => 'delegation_id',
         'vname' => 'LBL_DELEGATION_ID',
         'type' => 'varchar',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => '255',
         'size' => '20',
      ),
      'name' => array(
         'name' => 'name',
         'vname' => 'LBL_NAME',
         'type' => 'varchar',
         'dbType' => 'varchar',
         'len' => '255',
         'unified_search' => true,
         'required' => false,
         'importable' => 'true',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'size' => '20',
      ),
      'purpose' => array(
         'required' => true,
         'name' => 'purpose',
         'vname' => 'LBL_PURPOSE',
         'type' => 'enum',
         'massupdate' => 0,
         'default' => '',
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => '100',
         'size' => '20',
         'options' => 'delegation_purpose_list',
         'default' => '',
      ),
      'start_date' => array(
         'required' => true,
         'name' => 'start_date',
         'vname' => 'LBL_START_DATE',
         'type' => 'datetimecombo',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'size' => '20',
         'dbType' => 'datetime',
         'validation' => array('type' => 'isbefore', 'compareto' => 'end_date'),
      ),
      'end_date' => array(
         'required' => true,
         'name' => 'end_date',
         'vname' => 'LBL_END_DATE',
         'type' => 'datetimecombo',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'size' => '20',
         'dbType' => 'datetime',
      ),
      'transport_cost' => array(
         'required' => false,
         'name' => 'transport_cost',
         'vname' => 'LBL_TRANSPORT_COST',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'transport_cost_usdollar' => array(
         'required' => false,
         'name' => 'transport_cost_usdollar',
         'vname' => 'LBL_TRANSPORT_COST_USDOLLAR',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'transport_cost_eur' => array(
         'required' => false,
         'source' => 'non-db',
         'name' => 'transport_cost_eur',
         'vname' => 'LBL_TRANSPORT_COST',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'currency_id' => array(
         'required' => false,
         'name' => 'currency_id',
         'vname' => 'LBL_CURRENCY',
         'type' => 'id',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => 0,
         'audited' => true,
         'reportable' => true,
         'len' => 36,
         'size' => '20',
         'studio' => 'visible',
         'function' => array(
            'name' => 'getCurrencyDropDown',
            'returns' => 'html',
         ),
         'vt_calculated' => 'related(@currency_id,#delegationslocale)'
      ),
      'regiments' => array(
         'required' => false,
         'name' => 'regiments',
         'vname' => 'LBL_REGIMENTS',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'regiments_usdollar' => array(
         'required' => false,
         'name' => 'regiments_usdollar',
         'vname' => 'LBL_REGIMENTS_USDOLLAR',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'regiments_eur' => array(
         'required' => false,
         'source' => 'non-db',
         'name' => 'regiments_eur',
         'vname' => 'LBL_REGIMENTS',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'restaurant_bills' => array(
         'required' => false,
         'name' => 'restaurant_bills',
         'vname' => 'LBL_RESTAURANT_BILLS',
         'type' => 'int',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => '255',
         'size' => '20',
         'disable_num_format' => '',
      ),
      'documents' => array(
          'name' => 'documents',
          'type' => 'link',
          'relationship' => 'documents_delegations',
          'source' => 'non-db',
          'vname' => 'LBL_DOCUMENTS',
      ),
      'accomodations' => array(
         'required' => false,
         'name' => 'accomodations',
         'vname' => 'LBL_ACCOMODATIONS',
         'type' => 'varchar',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => '255',
         'size' => '20',
      ),
      'total_accommodation' => array(
         'required' => false,
         'name' => 'total_accommodation',
         'vname' => 'LBL_TOTAL_ACCOMMODATION',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'total_accommodation_usdollar' => array(
         'required' => false,
         'name' => 'total_accommodation_usdollar',
         'vname' => 'LBL_TOTAL_ACCOMMODATION_USDOLLAR',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'total_accommodation_eur' => array(
         'required' => false,
         'source' => 'non-db',
         'name' => 'total_accommodation_eur',
         'vname' => 'LBL_TOTAL_ACCOMMODATION',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'accommodation_lump_sum' => array(
         'required' => false,
         'name' => 'accommodation_lump_sum',
         'vname' => 'LBL_ACCOMMODATION_LUMP_SUM',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'accommodation_lump_sum_usdollar' => array(
         'required' => false,
         'name' => 'accommodation_lump_sum_usdollar',
         'vname' => 'LBL_ACCOMMODATION_LUMP_SUM_USDOLLAR',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'accommodation_lump_sum_eur' => array(
         'required' => false,
         'source' => 'non-db',
         'name' => 'accommodation_lump_sum_eur',
         'vname' => 'LBL_ACCOMMODATION_LUMP_SUM',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'other' => array(
         'required' => false,
         'name' => 'other',
         'vname' => 'LBL_OTHER',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'other_usdollar' => array(
         'required' => false,
         'name' => 'other_usdollar',
         'vname' => 'LBL_OTHER_USDOLLAR',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'other_eur' => array(
         'required' => false,
         'source' => 'non-db',
         'name' => 'other_eur',
         'vname' => 'LBL_OTHER',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'total_expenses' => array(
         'required' => false,
         'name' => 'total_expenses',
         'vname' => 'LBL_TOTAL_EXPENSES',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'total_expenses_usdollar' => array(
         'required' => false,
         'name' => 'total_expenses_usdollar',
         'vname' => 'LBL_TOTAL_EXPENSES_USDOLLAR',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'total_expenses_eur' => array(
         'required' => false,
         'source' => 'non-db',
         'name' => 'total_expenses_eur',
         'vname' => 'LBL_TOTAL_EXPENSES',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'obtained_sum' => array(
         'required' => false,
         'name' => 'obtained_sum',
         'vname' => 'LBL_OBTAINED_SUM',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'obtained_sum_usdollar' => array(
         'required' => false,
         'name' => 'obtained_sum_usdollar',
         'vname' => 'LBL_OBTAINED_SUM',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'obtained_sum_eur' => array(
         'required' => false,
         'source' => 'non-db',
         'name' => 'obtained_sum_eur',
         'vname' => 'LBL_OBTAINED_SUM',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'payoff_sum' => array(
         'required' => false,
         'name' => 'payoff_sum',
         'vname' => 'LBL_PAYOFF_SUM',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => false,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'payoff_sum_usdollar' => array(
         'required' => false,
         'name' => 'payoff_sum_usdollar',
         'vname' => 'LBL_PAYOFF_SUM_USDOLLAR',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => false,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'payoff_sum_eur' => array(
         'required' => false,
         'source' => 'non-db',
         'name' => 'payoff_sum_eur',
         'vname' => 'LBL_PAYOFF_SUM',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => false,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'return_sum' => array(
         'required' => false,
         'name' => 'return_sum',
         'vname' => 'LBL_RETURN_SUM',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => false,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'return_sum_usdollar' => array(
         'required' => false,
         'name' => 'return_sum_usdollar',
         'vname' => 'LBL_RETURN_SUM_USDOLLAR',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => false,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'return_sum_uer' => array(
         'required' => false,
         'source' => 'non-db',
         'name' => 'return_sum_eur',
         'vname' => 'LBL_RETURN_SUM',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => false,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'regimen_value' => array(
         'required' => false,
         'name' => 'regimen_value',
         'vname' => 'LBL_REGIMEN_VALUE',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'regimen_value_usdollar' => array(
         'required' => false,
         'name' => 'regimen_value_usdollar',
         'vname' => 'LBL_REGIMEN_VALUE',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'accommodation_value' => array(
         'required' => false,
         'name' => 'accommodation_value',
         'vname' => 'LBL_ACCOMMODATION_VALUE',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'accommodation_value_usdollar' => array(
         'required' => false,
         'name' => 'accommodation_value_usdollar',
         'vname' => 'LBL_ACCOMMODATION_VALUE',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'obtained_sum_usdollars' => array(
         'required' => false,
         'name' => 'obtained_sum_usdollars',
         'vname' => 'LBL_OBTAINED_SUM_BASE',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'transport_cost_usd' => array(
         'required' => false,
         'source' => 'non-db',
         'name' => 'transport_cost_usd',
         'vname' => 'LBL_TRANSPORT_COST',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
      ),
      'regiments_usd' => array(
         'required' => false,
         'source' => 'non-db',
         'name' => 'regiments_usd',
         'vname' => 'LBL_REGIMENTS',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
         'source' => 'non-db',
      ),
      'total_accommodation_usd' => array(
         'required' => false,
         'source' => 'non-db',
         'name' => 'total_accommodation_usd',
         'vname' => 'LBL_TOTAL_ACCOMMODATION',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
         'source' => 'non-db',
      ),
      'accommodation_lump_sum_usd' => array(
         'required' => false,
         'source' => 'non-db',
         'name' => 'accommodation_lump_sum_usd',
         'vname' => 'LBL_ACCOMMODATION_LUMP_SUM',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
         'source' => 'non-db',
      ),
      'other_usd' => array(
         'required' => false,
         'source' => 'non-db',
         'name' => 'other_usd',
         'vname' => 'LBL_OTHER',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
         'source' => 'non-db',
      ),
      'total_expenses_usd' => array(
         'required' => false,
         'source' => 'non-db',
         'name' => 'total_expenses_usd',
         'vname' => 'LBL_TOTAL_EXPENSES',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
         'source' => 'non-db',
      ),
      'obtained_sum_usd' => array(
         'required' => false,
         'source' => 'non-db',
         'name' => 'obtained_sum_usd',
         'vname' => 'LBL_OBTAINED_SUM',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
         'source' => 'non-db',
      ),
      'payoff_sum_usd' => array(
         'required' => false,
         'source' => 'non-db',
         'name' => 'payoff_sum_usd',
         'vname' => 'LBL_PAYOFF_SUM',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => false,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
         'source' => 'non-db',
      ),
      'return_sum_uer' => array(
         'required' => false,
         'source' => 'non-db',
         'name' => 'return_sum_usd',
         'vname' => 'LBL_RETURN_SUM',
         'type' => 'currency',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => false,
         'reportable' => true,
         'len' => 26,
         'size' => '20',
         'precision' => 2,
         'source' => 'non-db',
      ),
      'restaurant_bills_eur' => array(
         'source' => 'non-db',
         'required' => false,
         'name' => 'restaurant_bills_eur',
         'vname' => 'LBL_RESTAURANT_BILLS',
         'type' => 'int',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => '255',
         'size' => '20',
         'disable_num_format' => '',
      ),
      'restaurant_bills_usd' => array(
         'source' => 'non-db',
         'required' => false,
         'name' => 'restaurant_bills_usd',
         'vname' => 'LBL_RESTAURANT_BILLS',
         'type' => 'int',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => '255',
         'size' => '20',
         'disable_num_format' => '',
      ),
      'owner' => array(
         'required' => false,
         'name' => 'owner',
         'vname' => 'LBL_OWNER',
         'type' => 'bool',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => '255',
         'size' => '20',
      ),
      'exchange_rate' => array(
         'required' => true,
         'name' => 'exchange_rate',
         'vname' => 'LBL_EXCHANGE_RATE',
         'type' => 'float',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => '18',
         'size' => '20',
         'precision' => '4',
         'vt_dependency' => 'not(equals($currency_id,-99))'
      ),
      'assured_number_of_breakfasts' => array(
         'required' => true,
         'name' => 'assured_number_of_breakfasts',
         'vname' => 'LBL_ASSURED_NUMBER_OF_BREAKFASTS',
         'type' => 'int',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => '255',
         'size' => '20',
         'disable_num_format' => '',
         'default' => '0',
      ),
      'assured_number_of_dinners' => array(
         'required' => true,
         'name' => 'assured_number_of_dinners',
         'vname' => 'LBL_ASSURED_NUMBER_OF_DINNERS',
         'type' => 'int',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => '255',
         'size' => '20',
         'disable_num_format' => '',
         'default' => '0',
      ),
      'assured_number_of_suppers' => array(
         'required' => true,
         'name' => 'assured_number_of_suppers',
         'vname' => 'LBL_ASSURED_NUMBER_OF_SUPPERS',
         'type' => 'int',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => '255',
         'size' => '20',
         'disable_num_format' => '',
         'default' => '0',
      ),
      'assured_number_of_accommodations' => array(
         'required' => true,
         'name' => 'assured_number_of_accommodations',
         'vname' => 'LBL_ASSURED_NUMBER_OF_ACCOMMODATIONS',
         'type' => 'int',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => '255',
         'size' => '20',
         'disable_num_format' => '',
         'default' => '0',
      ),
      'costs_sum' => array(
         'required' => true,
         'name' => 'costs_sum',
         'vname' => 'LBL_COSTS_SUM',
         'type' => 'float',
         'massupdate' => 0,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'len' => '18',
         'size' => '20',
         'precision' => '2',
      ),
      "costs" => array(
         'name' => 'costs',
         'type' => 'link',
         'relationship' => 'costs_delegations',
         'source' => 'non-db',
         'side' => 'right',
         'vname' => 'LBL_COSTS',
      ),
      "transportations" => array(
         'name' => 'transportations',
         'type' => 'link',
         'relationship' => 'transportations_delegations',
         'source' => 'non-db',
         'side' => 'right',
         'vname' => 'LBL_TRANSPORTATIONS',
      ),
      "delegationslocale" => array(
         'name' => 'delegationslocale',
         'type' => 'link',
         'relationship' => 'delegationslocale_delegations',
         'source' => 'non-db',
         'vname' => 'LBL_DELEGATIONSLOCALE',
         'id_name' => 'delegation_locale_id',
      ),
      "delegation_locale_name" => array(
         'name' => 'delegation_locale_name',
         'type' => 'relate',
         'source' => 'non-db',
         'vname' => 'LBL_DELEGATION_LOCALE_NAME',
         'save' => true,
         'id_name' => 'delegation_locale_id',
         'link' => 'delegationslocale',
         'table' => 'delegationslocale',
         'module' => 'DelegationsLocale',
         'rname' => 'name',
         'audited' => true,
      ),
      "delegation_locale_id" => array(
         'name' => 'delegation_locale_id',
         'type' => 'id',
         'relationship' => 'delegationslocale_delegations',
         'reportable' => false,
         'vname' => 'LBL_DELEGATION_LOCALE_ID',
         'rname' => 'id',
         'isnull' => 'true',
         'dbType' => 'id',
      ),
      "workschedules" => array(
         'name' => 'workschedules',
         'type' => 'link',
         'relationship' => 'delegations_workschedules',
         'source' => 'non-db',
         'side' => 'right',
         'vname' => 'LBL_WORKSCHEDULES',
      ),
      "reservations" => array(
         'name' => 'reservations',
         'type' => 'link',
         'relationship' => 'delegations_reservations',
         'source' => 'non-db',
         'module' => 'Reservations',
         'bean_name' => 'Reservations',
         'side' => 'right',
         'vname' => 'LBL_RESERVATIONS',
      ),
   ),
   'relationships' => array(
      'delegationslocale_delegations' => array(
         'lhs_module' => 'DelegationsLocale',
         'lhs_table' => 'delegationslocale',
         'lhs_key' => 'id',
         'rhs_module' => 'Delegations',
         'rhs_table' => 'delegations',
         'rhs_key' => 'delegation_locale_id',
         'relationship_type' => 'one-to-many',
      ),
      'delegations_workschedules' => array(
         'lhs_module' => 'Delegations',
         'lhs_table' => 'delegations',
         'lhs_key' => 'id',
         'rhs_module' => 'WorkSchedules',
         'rhs_table' => 'workschedules',
         'rhs_key' => 'delegation_id',
         'relationship_type' => 'one-to-many',
      ),
   ),
   'indices' => array(
      array(
         'name' => 'idx_delegation_locale_id',
         'type' => 'index',
         'fields' => array(
            0 => 'delegation_locale_id',
         ),
      ),
   ),
   'optimistic_locking' => true,
);
if ( !class_exists('VardefManager') ) {
   require_once('include/SugarObjects/VardefManager.php');
}
VardefManager::createVardef('Delegations', 'Delegations', array( 'basic', 'assignable', 'security_groups' ));

$dictionary['Delegations']['fields']['assigned_user_name']['required'] = true;
