<?php

$dictionary['SecurityGroup'] = [
    'table' => 'securitygroups',
    'audited' => true,
    'fields' => [
        'noninheritable' => [
            'name' => 'noninheritable',
            'vname' => 'LBL_NONINHERITABLE',
            'type' => 'bool',
            'reportable' => false,
            'comment' => 'Indicator for whether a group can be inherited by a record',
        ],
        'users' => [
            'name' => 'users',
            'type' => 'link',
            'relationship' => 'securitygroups_users',
            'source' => 'non-db',
            'vname' => 'LBL_USERS',
        ],
        'aclroles' => [
            'name' => 'aclroles',
            'type' => 'link',
            'relationship' => 'securitygroups_acl_roles',
            'source' => 'non-db',
            'vname' => 'LBL_ROLES',
        ],
        /** related editable fields with Users module */
        'securitygroup_noninher_fields' => [
            'name' => 'securitygroup_noninher_fields',
            'rname' => 'id',
            'relationship_fields' => [
                'id' => 'securitygroup_noninherit_id',
                'noninheritable' => 'securitygroup_noninheritable',
                'primary_group' => 'securitygroup_primary_group',
            ],
            'vname' => 'LBL_USER_NAME',
            'type' => 'relate',
            'link' => 'users',
            'link_type' => 'relationship_info',
            'source' => 'non-db',
            'Importable' => false,
            'duplicate_merge' => 'disabled',
        ],
        'securitygroup_noninherit_id' => [
            'name' => 'securitygroup_noninherit_id',
            'type' => 'varchar',
            'source' => 'non-db',
            'vname' => 'LBL_securitygroup_noninherit_id',
        ],
        'securitygroup_noninheritable' => [
            'name' => 'securitygroup_noninheritable',
            'type' => 'bool',
            'source' => 'non-db',
            'vname' => 'LBL_SECURITYGROUP_NONINHERITABLE',
        ],
        'securitygroup_primary_group' => [
            'name' => 'securitygroup_primary_group',
            'type' => 'bool',
            'source' => 'non-db',
            'vname' => 'LBL_PRIMARY_GROUP',
        ],
        'group_type' => [
            'required' => false,
            'name' => 'group_type',
            'vname' => 'LBL_GROUP_TYPE',
            'type' => 'enum',
            'massupdate' => false,
            'default' => 'department',
            'no_default' => false,
            'comments' => '',
            'help' => '',
            'importable' => 'true',
            'duplicate_merge' => 'disabled',
            'duplicate_merge_dom_value' => '0',
            'audited' => true,
            'reportable' => true,
            'unified_search' => false,
            'merge_filter' => 'disabled',
            'calculated' => false,
            'len' => 100,
            'size' => '20',
            'options' => 'group_type_list',
            'studio' => 'visible',
        ],
        'positions_leader' => array(
            'name' => 'positions_leader',
            'type' => 'link',
            'relationship' => 'securitygroups_positions_leader',
            'source' => 'non-db',
            'module' => 'Positions',
            'bean_name' => 'Positions',
            'vname' => 'LBL_POSITIONS_LEADER',
            'id_name' => 'position_leader_id',
        ),
        'position_leader_name' => array(
            'name' => 'position_leader_name',
            'type' => 'relate',
            'source' => 'non-db',
            'vname' => 'LBL_POSITION_LEADER_NAME',
            'save' => true,
            'id_name' => 'position_leader_id',
            'link' => 'positions_leader',
            'table' => 'positions',
            'module' => 'Positions',
            'rname' => 'name',
        ),
        'position_leader_id' => array(
            'name' => 'position_leader_id',
            'type' => 'link',
            'relationship' => 'securitygroups_positions_leader',
            'source' => 'non-db',
            'reportable' => false,
            'side' => 'left',
            'vname' => 'LBL_POSITION_LEADER_ID',
            'audited' => true,
            'mandatory_fetch' => true,
        ),
        'positions_membership' => array(
            'name' => 'positions_membership',
            'type' => 'link',
            'relationship' => 'securitygroups_positions_membership',
            'source' => 'non-db',
            'module' => 'Positions',
            'bean_name' => 'Positions',
            'vname' => 'LBL_POSITIONS_MEMBERSHIP',
        ),
        'member_of' => array(
            'name' => 'member_of',
            'type' => 'link',
            'relationship' => 'member_securitygroups',
            'module' => 'SecurityGroups',
            'bean_name' => 'SecurityGroup',
            'link_type' => 'one',
            'source' => 'non-db',
            'vname' => 'LBL_MEMBER_OF',
            'side' => 'right',
        ),
        'parent_id' => array(
            'name' => 'parent_id',
            'vname' => 'LBL_PARENT_ID',
            'type' => 'id',
            'required' => false,
            'reportable' => false,
            'audited' => true,
        ),
        'parent_name' => array(
            'name' => 'parent_name',
            'rname' => 'name',
            'id_name' => 'parent_id',
            'vname' => 'LBL_MEMBER_OF',
            'type' => 'relate',
            'isnull' => 'true',
            'module' => 'SecurityGroups',
            'table' => 'securitygroups',
            'massupdate' => false,
            'source' => 'non-db',
            'len' => 36,
            'link' => 'member_of',
            'unified_search' => true,
            'importable' => 'true',
            'vt_validation' => "AEM(callCustomApi('SecurityGroups', 'checkSubordinatedGroups', {id:\$id, parent_id:\$parent_id}), 'LBL_PARENT_GROUP_ERROR')",
        ),
        "current_manager" => array(
            'name' => 'current_manager',
            'type' => 'link',
            'relationship' => 'employees_securitygroups',
            'source' => 'non-db',
            'module' => 'Employees',
            'bean_name' => 'Employee',
            'vname' => 'LBL_CURRENT_MANAGER',
            'id_name' => 'current_manager_id',
        ),
        "current_manager_name" => array(
            'name' => 'current_manager_name',
            'type' => 'relate',
            'source' => 'non-db',
            'vname' => 'LBL_CURRENT_MANAGER_NAME',
            'save' => true,
            'id_name' => 'current_manager_id',
            'link' => 'current_manager',
            'module' => 'Employees',
            'table' => 'users',
            'rname' => 'name',
            'audited' => true,
            'importable' => true,
            'reportable' => true,
            'massupdate' => false,
            'duplicate_merge' => 'enabled',
        ),
        "current_manager_id" => array(
            'name' => 'current_manager_id',
            'relationship' => 'employees_securitygroups',
            'type' => 'id',
            'vname' => 'LBL_CURRENT_MANAGER_ID',
            'audited' => false,
            'reportable' => true,
        ),
        "onboardingoffboardingelements" => array(
            'name' => 'onboardingoffboardingelements',
            'type' => 'link',
            'relationship' => 'securitygroups_unit_onboardingoffboardingelements',
            'source' => 'non-db',
            'module' => 'OnboardingOffboardingElements',
            'bean_name' => 'OnboardingOffboardingElements',
            'side' => 'left',
            'vname' => 'LBL_ONBOARDINGOFFBOARDINGELEMENTS',
        ),
        'members' => array(
            'name' => 'members',
            'type' => 'link',
            'relationship' => 'member_securitygroups',
            'module' => 'SecurityGroups',
            'bean_name' => 'SecurityGroup',
            'source' => 'non-db',
            'vname' => 'LBL_MEMBERS',
        ),
        'employees' => array(
            'name' => 'employees',
            'type' => 'link',
            'relationship' => 'securitygroups_employees',
            'source' => 'non-db',
            'module' => 'Employees',
            'bean_name' => 'Employee',
            'side' => 'right',
            'vname' => 'LBL_EMPLOYEES',
        ),
    ],
    'relationships' => [
        "employees_securitygroups" => array(
            'lhs_module' => 'Employees',
            'lhs_table' => 'users',
            'lhs_key' => 'id',
            'rhs_module' => 'SecurityGroups',
            'rhs_table' => 'securitygroups',
            'rhs_key' => 'current_manager_id',
            'relationship_type' => 'one-to-many',
        ),
        "securitygroups_employees" => array(
            'lhs_module' => 'SecurityGroups',
            'lhs_table' => 'securitygroups',
            'lhs_key' => 'id',
            'rhs_module' => 'Employees',
            'rhs_table' => 'users',
            'rhs_key' => 'securitygroup_id',
            'relationship_type' => 'one-to-many',
        ),
        'member_securitygroups' => array(
            'lhs_module' => 'SecurityGroups',
            'lhs_table' => 'securitygroups',
            'lhs_key' => 'id',
            'rhs_module' => 'SecurityGroups',
            'rhs_table' => 'securitygroups',
            'rhs_key' => 'parent_id',
            'relationship_type' => 'one-to-many',
        ),
    ],
    'optimistic_lock' => true,
];
require_once 'include/SugarObjects/VardefManager.php';
VardefManager::createVardef('SecurityGroups', 'SecurityGroup', ['basic', 'assignable']);

$dictionary["SecurityGroup"]["fields"]["securitygroups_rooms"] = array (
    'name' => 'securitygroups_rooms',
    'type' => 'link',
    'relationship' => 'securitygroups_rooms',
    'source' => 'non-db',
    'module' => 'Rooms',
    'bean_name' => 'Rooms',
    'vname' => 'LBL_RELATIONSHIP_ROOMS_NAME',
    'side' => 'right',
 );