<?php

/**
 *
 * SugarCRM Community Edition is a customer relationship management program developed by
 * SugarCRM, Inc. Copyright (C) 2004-2013 SugarCRM Inc.
 *
 * SuiteCRM is an extension to SugarCRM Community Edition developed by SalesAgility Ltd.
 * Copyright (C) 2011 - 2018 SalesAgility Ltd.
 *
 * MintHCM is a Human Capital Management software based on SuiteCRM developed by MintHCM, 
 * Copyright (C) 2018-2023 MintHCM
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.
 *
 * You can contact SugarCRM, Inc. headquarters at 10050 North Wolfe Road,
 * SW2-130, Cupertino, CA 95014, USA. or at email address contact@sugarcrm.com.
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License version 3.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License version 3,
 * these Appropriate Legal Notices must retain the display of the "Powered by SugarCRM" 
 * logo and "Supercharged by SuiteCRM" logo and "Reinvented by MintHCM" logo. 
 * If the display of the logos is not reasonably feasible for technical reasons, the 
 * Appropriate Legal Notices must display the words "Powered by SugarCRM" and 
 * "Supercharged by SuiteCRM" and "Reinvented by MintHCM".
 */

$dictionary['WorkSchedules'] = array(
   'table' => 'workschedules',
   'audited' => true,
   'duplicate_merge' => true,
   'fields' => array(
      'repeat_pane' => array(
         'name' => 'repeat_pane',
         'vname' => 'LBL_REPEAT_PANE',
         'type' => 'varchar',
         'source' => 'non-db',
         'comment' => 'Repeat Pane',
         'importable' => 'false',
         'massupdate' => false,
         'reportable' => false,
         'studio' => 'false',
         'required' => false,
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
      ),
      'repeat_type' => array(
         'name' => 'repeat_type',
         'vname' => 'LBL_REPEAT_TYPE',
         'type' => 'enum',
         'len' => 36,
         'options' => 'repeat_type_dom',
         'comment' => 'Type of recurrence',
         'importable' => 'false',
         'massupdate' => false,
         'reportable' => false,
         'studio' => 'false',
      ),
      'repeat_interval' => array(
         'name' => 'repeat_interval',
         'vname' => 'LBL_REPEAT_INTERVAL',
         'type' => 'int',
         'len' => 3,
         'default' => 1,
         'comment' => 'Interval of recurrence',
         'importable' => 'false',
         'massupdate' => false,
         'reportable' => false,
         'studio' => 'false',
      ),
      'repeat_dow' => array(
         'name' => 'repeat_dow',
         'vname' => 'LBL_REPEAT_DOW',
         'type' => 'varchar',
         'len' => 7,
         'comment' => 'Days of week in recurrence',
         'importable' => 'false',
         'massupdate' => false,
         'reportable' => false,
         'studio' => 'false',
      ),
      'repeat_until' => array(
         'name' => 'repeat_until',
         'vname' => 'LBL_REPEAT_UNTIL',
         'type' => 'date',
         'comment' => 'Repeat until specified date',
         'importable' => 'false',
         'massupdate' => false,
         'reportable' => false,
         'studio' => 'false',
      ),
      'repeat_count' => array(
         'name' => 'repeat_count',
         'vname' => 'LBL_REPEAT_COUNT',
         'type' => 'int',
         'len' => 7,
         'comment' => 'Number of recurrence',
         'importable' => 'false',
         'massupdate' => false,
         'reportable' => false,
         'studio' => 'false',
      ),
      'repeat_parent_id' => array(
         'name' => 'repeat_parent_id',
         'vname' => 'LBL_REPEAT_PARENT_ID',
         'type' => 'id',
         'len' => 36,
         'comment' => 'Id of the first element of recurring records',
         'importable' => 'false',
         'massupdate' => false,
         'reportable' => false,
         'studio' => 'false',
      ),
      'lp' => array(
         'required' => false,
         'name' => 'lp',
         'vname' => 'LBL_LP',
         'type' => 'int',
         'massupdate' => 0,
         'no_default' => false,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => false,
         'reportable' => true,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'len' => '255',
         'size' => '20',
         'enable_range_search' => false,
         'disable_num_format' => '',
         'min' => false,
         'max' => false,
      ),
      'type' => array(
         'required' => false,
         'name' => 'type',
         'vname' => 'LBL_TYPE',
         'type' => 'enum',
         'massupdate' => 0,
         'default' => 'office',
         'no_default' => false,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'len' => 100,
         'size' => '20',
         'options' => 'workschedule_type_list',
         'studio' => 'visible',
         'dependency' => false,
         'vt_validation' => "AEM(callCustomApi('WorkSchedules','canChangeTypeToWorkOff',{id:\$id,type:\$type}),'LBL_ERR_CANT_CHANGE_TYPE_TO_WORK_OFF')",
      ),
      'status' => array(
         'required' => false,
         'name' => 'status',
         'vname' => 'LBL_STATUS',
         'type' => 'ColoredEnum',
         'dbType' => 'varchar',
         'massupdate' => 0,
         'default' => 'planned',
         'no_default' => false,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'len' => 100,
         'size' => '20',
         'options' => 'workschedules_status_dom',
         'options_colors' => 'workschedules_status_dom_colored',
         'studio' => 'visible',
         'dependency' => false,
         'vt_validation' => "AEM(callCustomApi('WorkSchedules','canChangeWorkScheduleStatus',{id:\$id,status:\$status}),'LBL_ERR_CANNOT_CHANGE_WORK_SCHEDULE_STATUS')",
      ),
      'supervisor_acceptance' => array(
         'required' => false,
         'name' => 'supervisor_acceptance',
         'vname' => 'LBL_SUPERVISOR_ACCEPTANCE',
         'type' => 'enum',
         'massupdate' => 1,
         'default' => 'wait',
         'no_default' => false,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'len' => 100,
         'size' => '20',
         'options' => 'supervisor_acceptance_dom',
         'studio' => 'visible',
         'dependency' => false,
         'vt_dependency' => "inArray(\$type,'holiday','overtime','home')",
      ),
      'schedule_date' => array(
         'required' => false,
         'name' => 'schedule_date',
         'vname' => 'LBL_SCHEDULE_DATE',
         'type' => 'date',
         'massupdate' => 0,
         'no_default' => false,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => false,
         'reportable' => true,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'size' => '20',
         'enable_range_search' => true,
         'options' => 'date_range_search_dom',
      ),
      'date_start' => array(
         'required' => true,
         'name' => 'date_start',
         'vname' => 'LBL_DATE_START',
         'type' => 'datetimecombo',
         'massupdate' => 0,
         'no_default' => false,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'size' => '20',
         'enable_range_search' => true,
         'options' => 'date_range_search_dom',
         'dbType' => 'datetime',
      ),
      'date_end' => array(
         'required' => true,
         'name' => 'date_end',
         'vname' => 'LBL_DATE_END',
         'type' => 'datetimecombo',
         'massupdate' => 0,
         'no_default' => false,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'size' => '20',
         'enable_range_search' => true,
         'dbType' => 'datetime',
         'options' => 'date_range_search_dom',
      ),
      'duration_minutes' => array(
         'required' => false,
         'name' => 'duration_minutes',
         'vname' => 'LBL_DURATION_MINUTES',
         'type' => 'int',
         'massupdate' => 0,
         'no_default' => false,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'len' => '255',
         'size' => '20',
         'enable_range_search' => false,
         'disable_num_format' => '',
         'min' => false,
         'max' => false,
      ),
      'duration_hours' => array(
         'required' => true,
         'name' => 'duration_hours',
         'vname' => 'LBL_DURATION_HOURS',
         'type' => 'int',
         'massupdate' => 0,
         'no_default' => false,
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'len' => '255',
         'size' => '20',
         'enable_range_search' => false,
         'disable_num_format' => '',
         'min' => false,
         'max' => false,
      ),
      'spent_time' => array(
         'required' => false,
         'name' => 'spent_time',
         'vname' => 'LBL_SPENT_TIME',
         'type' => 'float',
         'massupdate' => 0,
         'default' => '0',
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'len' => '18',
         'size' => '20',
         'enable_range_search' => true,
         'options' => 'numeric_range_search_dom',
         'precision' => '2',
      ),
      'spent_time_settlement' => array(
         'required' => false,
         'name' => 'spent_time_settlement',
         'vname' => 'LBL_SPENT_TIME_SETTLEMENT',
         'type' => 'float',
         'massupdate' => false,
         'default' => '0',
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => true,
         'reportable' => true,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'len' => '18',
         'size' => '20',
         'enable_range_search' => false,
         'precision' => '2',
      ),
      'delegation_duration' => array(
         'required' => true,
         'name' => 'delegation_duration',
         'vname' => 'LBL_DELEGATION_DURATION',
         'type' => 'float',
         'massupdate' => false,
         'default' => '0',
         'comments' => '',
         'help' => '',
         'importable' => 'true',
         'duplicate_merge' => 'disabled',
         'duplicate_merge_dom_value' => '0',
         'audited' => false,
         'reportable' => true,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'len' => '18',
         'size' => '20',
         'enable_range_search' => true,
         'options' => 'numeric_range_search_dom',
         'precision' => '2',
         'vt_dependency' => "equals(\$type,'delegation')",
         // MintHCM #66889, #89498 START
         'vt_validation' => "AEM(ifElse(equals(\$type,'delegation'),callCustomApi('WorkSchedules','validateDelegationDurationValue',\$delegation_duration),true),'LBL_ERR_DELEGATION_DURATION_NOT_VALID')",
         // MintHCM #66889, #89498 END
      ),
      'comments' => array(
         'name' => 'comments',
         'vname' => 'LBL_COMMENTS',
         'required' => false,
         'type' => 'varchar',
         'massupdate' => false,
         'importable' => 'true',
         'duplicate_merge' => false,
         'audited' => true,
         'reportable' => false,
         'len' => '255',
         'size' => '20',
         'vt_dependency' => "inArray(\$type,'occasional_leave','excused_absence')",
      ),
      'time_tracking_pane' => array(
         'name' => 'time_tracking_pane',
         'vname' => 'LBL_TIME_TRACKING_PANE',
         'required' => false,
         'type' => 'varchar',
         'massupdate' => false,
         'importable' => false,
         'duplicate_merge' => false,
         'audited' => false,
         'reportable' => false,
         'len' => '255',
         'size' => '20',
         'source' => 'non-db',
      ),
      'occasional_leave_type' => array(
         'name' => 'occasional_leave_type',
         'vname' => 'LBL_OCCASIONAL_LEAVE_TYPE',
         'required' => false,
         'type' => 'enum',
         'massupdate' => false,
         'importable' => 'true',
         'duplicate_merge' => false,
         'audited' => true,
         'reportable' => true,
         'unified_search' => false,
         'merge_filter' => 'disabled',
         'len' => 100,
         'size' => '20',
         'options' => 'occasional_leave_type_dom',
         'vt_dependency' => "equals(\$type,'occasional_leave')",
         'vt_required' => "equals(\$type,'occasional_leave')",
      ),
      'spenttimes' => array(
         'name' => 'spenttimes',
         'type' => 'link',
         'relationship' => 'workschedules_spenttime',
         'source' => 'non-db',
         'module' => 'SpentTime',
         'bean_name' => 'SpentTime',
         'vname' => 'LBL_SPENTTIMES',
      ),
      'delegations' => array(
         'name' => 'delegations',
         'type' => 'link',
         'relationship' => 'delegations_workschedules',
         'source' => 'non-db',
         'vname' => 'LBL_DELEGATIONS',
         'id_name' => 'delegation_id',
      ),
      'delegation_name' => array(
         'name' => 'delegation_name',
         'type' => 'relate',
         'source' => 'non-db',
         'vname' => 'LBL_DELEGATIONS',
         'save' => true,
         'id_name' => 'delegation_id',
         'link' => 'delegations_workschedules',
         'table' => 'delegations',
         'module' => 'Delegations',
         'rname' => 'name',
         'audited' => true,
         'vt_dependency' => "or(equals(\$type,'delegation'),equals(\$type,'home'))",
      ),
      'delegation_id' => array(
         'name' => 'delegation_id',
         'type' => 'id',
         'relationship' => 'delegations_workschedules',
         'reportable' => false,
         'vname' => 'LBL_DELEGATIONS',
         'rname' => 'id',
         'isnull' => 'true',
         'dbType' => 'id',
      ),
      "workplaces_workschedules" => array(
         'name' => 'workplaces_workschedules',
         'type' => 'link',
         'relationship' => 'workplaces_workschedules',
         'source' => 'non-db',
         'module' => 'Workplaces',
         'bean_name' => 'Workplaces',
         'vname' => 'LBL_RELATIONSHIP_WORKPLACE_NAME',
         'id_name' => 'workplace_id',
      ),
      "workplace_name" => array(
         'name' => 'workplace_name',
         'type' => 'relate',
         'source' => 'non-db',
         'vname' => 'LBL_RELATIONSHIP_WORKPLACE_NAME',
         'id_name' => 'workplace_id',
         'link' => 'workplaces_workschedules',
         'module' => 'Workplaces',
         'table' => 'workplaces',
         'rname' => 'name',
         'vt_dependency' => "equals(\$type,'office')",
         'vt_validation' => array(
            "AEM(callCustomApi('WorkSchedules','validateWorkplaceStatus',{id:\$workplace_id}),'LBL_ERR_STATUS_NOT_ACTIVE')",
            "AEM(callCustomApi('WorkSchedules','validateWorkplaceAllocationPeriods',{workplace_id:\$workplace_id,date_start:\$date_start,date_end:\$date_end}),'LBL_ERR_WORKPLACE_NOT_ACTIVE')",
         ),
      ),
      "workplace_id" => array(
         'name' => 'workplace_id',
         'relationship' => 'workplaces_workschedules',
         'type' => 'id',
         'vname' => 'LBL_RELATIONSHIP_WORKPLACE_ID', 
         'audited' => true,
      ),
      "deputy" => array(
         'name' => 'deputy',
         'type' => 'link',
         'relationship' => 'deputy_workschedules',
         'source' => 'non-db',
         'module' => 'Users',
         'bean_name' => 'Users',
         'vname' => 'LBL_DEPUTY',
         'id_name' => 'deputy_id',
      ),
      "deputy_name" => array(
         'name' => 'deputy_name',
         'type' => 'relate',
         'source' => 'non-db',
         'vname' => 'LBL_DEPUTY_NAME',
         'id_name' => 'deputy_id',
         'link' => 'deputy_workschedules',
         'module' => 'Users',
         'table' => 'users',
         'rname' => 'user_name',
         'vt_dependency' => "inArray(\$type,'holiday', 'sick', 'sick_care', 'occasional_leave', 'leave_at_request', 'overtime', 'excused_absence')",
      ),
      "deputy_id" => array(
         'name' => 'deputy_id',
         'relationship' => 'deputy_workschedules',
         'type' => 'id',
         'vname' => 'LBL_DEPUTY_ID', 
         'audited' => true,
      ),
   ),
   'indices' => array(
      array(
        'name' => 'idx_workschedule_name',
        'type' => 'index',
        'fields' => array('name'),
      ),
      array(
        'name' => 'idx_workschedule_type',
        'type' => 'index',
        'fields' => array('type'),
      ),
      array(
        'name' => 'idx_workschedule_status',
        'type' => 'index',
        'fields' => array('status'),
      ),
      array(
        'name' => 'idx_workschedule_date_start',
        'type' => 'index',
        'fields' => array('date_start'),
      ),
      array(
        'name' => 'idx_workschedule_date_end',
        'type' => 'index',
        'fields' => array('date_end'),
      ),
   ),
   'relationships' => array(
      "workplaces_workschedules" => array(
         'lhs_module' => 'Workplaces',
         'lhs_table' => 'workplaces',
         'lhs_key' => 'id',
         'rhs_module' => 'WorkSchedules',
         'rhs_table' => 'workschedules',
         'rhs_key' => 'workplace_id',
         'relationship_type' => 'one-to-many',
      ),
      "deputy_workschedules" => array(
         'lhs_module' => 'Users',
         'lhs_table' => 'users',
         'lhs_key' => 'id',
         'rhs_module' => 'WorkSchedules',
         'rhs_table' => 'workschedules',
         'rhs_key' => 'deputy_id',
         'relationship_type' => 'one-to-many',
      ),
   ),
   'optimistic_locking' => true,
   'unified_search' => true,
);
if ( !class_exists('VardefManager') ) {
    require_once 'include/SugarObjects/VardefManager.php';
}
VardefManager::createVardef('WorkSchedules', 'WorkSchedules', array(
   'basic',
   'assignable',
   'security_groups',
));
if ( is_array($dictionary['WorkSchedules']['fields']['assigned_user_name']) ) {
   $dictionary['WorkSchedules']['fields']['assigned_user_name']['vt_validation'] = "AEM(isSuperior(\$assigned_user_id),'LBL_WRONG_ASSIGNED_USER')";
}
